<?php
/*--------------------------------------------------------------
   MaxEntriesDropdown.php 2021-06-28
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2021 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
 -------------------------------------------------------------*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Statistics\App\Overview\Factory\Option\Predefined;

use Gambio\Admin\Modules\Statistics\App\Overview\Factory;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\DropdownItems;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\Collections\OptionTitles;
use Gambio\Admin\Modules\Statistics\App\Overview\Model\ValueObjects\Option\Dropdown;

class MaxEntriesDropdown
{
    public const ID = "maxEntries";
    
    private const DEFAULT_VALUE = "5";
    
    private const ITEMS = ["5", "10", "20"];
    
    private const LANGUAGE_CODE_GERMAN = "de";
    
    private const LANGUAGE_CODE_ENGLISH = "en";
    
    private const TITLES = [
        self::LANGUAGE_CODE_GERMAN  => "Max. Einträge",
        self::LANGUAGE_CODE_ENGLISH => "Max. Entries"
    ];
    
    
    /**
     * Return dropdown.
     */
    public static function create(Factory $factory): Dropdown
    {
        return $factory->useOptions()->useDropdowns()->createDropdown($factory->useOptions()->createId(self::ID),
                                                                      self::DEFAULT_VALUE,
                                                                      self::createItems($factory),
                                                                      self::createTitles($factory));
    }
    
    
    /**
     * Return titles.
     */
    private static function createTitles(Factory $factory): OptionTitles
    {
        return $factory->useOptions()
            ->createTitles(...array_map(function (string $languageCode, string $title) use ($factory) {
                return $factory->useOptions()->createTitle($factory->createLanguageCode($languageCode), $title);
            },
                array_keys(self::TITLES),
                self::TITLES));
    }
    
    
    /**
     * Return items.
     */
    private static function createItems(Factory $factory): DropdownItems
    {
        return $factory->useOptions()->useDropdowns()->createItems(...array_map(function (string $item) use ($factory) {
            return $factory->useOptions()->useDropdowns()->createItem($factory->useOptions()
                                                                          ->useDropdowns()
                                                                          ->createValue($item),
                                                                      $factory->useOptions()
                                                                          ->useDropdowns()
                                                                          ->createItemTitles($factory->useOptions()
                                                                                                 ->useDropdowns()
                                                                                                 ->createItemTitle($factory->createLanguageCode(self::LANGUAGE_CODE_GERMAN),
                                                                                                                   $item),
                                                                                             $factory->useOptions()
                                                                                                 ->useDropdowns()
                                                                                                 ->createItemTitle($factory->createLanguageCode(self::LANGUAGE_CODE_ENGLISH),
                                                                                                                   $item)));
        },
            self::ITEMS));
    }
}